// config: norepeat

#include "GetObjects.js"

function DoTrim()
{
	moi.command.registerCommandSpecificShortcutKey( 'Delete' ); // Register delete key to trigger a UI event.

	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowFaces();
	objectpicker.allowBReps();
	
	if ( !GetObjects( objectpicker ) )
		return;

	var factory = moi.command.createFactory( 'trim' );
		
	var objects = objectpicker.objects;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.showUI( 'SelectCuttersPrompt' );
	moi.ui.showUI( 'DeleteCuttingObjectsContainer' );
	
	// If there are curves, then set up some options for curve cutters.
	if ( objects.numCurves > 0 )
	{
		moi.ui.showUI( 'CurveCutterOptions' );

		// Bind the extendlines and projectedintersections checkboxes to the factory inputs.
		moi.ui.bindUIToInput( 'extendlines', 'value', factory.getInput(4) );
		moi.ui.bindUIToInput( 'projectedintersections', 'value', factory.getInput(5) );
	}
	
	// Show Isocurve button if a single surface is selected as the object to trim.
	if ( objects.length == 1 && (objects.numFaces == 1 || objects.numSingleFaceBReps == 1) )
	{
		moi.ui.showUI( 'SurfaceCutterOptions' );
	}
		
	moi.ui.endUIUpdate();
	
	// Allow any type of curve including edge curves, and also points as cutting objects.
	objectpicker.allowCurves();
	objectpicker.allowPointObjects();
	
	while ( 1 )
	{
		if ( !objectpicker.waitForEvent() )
			return false;
			
		if ( objectpicker.event == 'finished' )
		{
			break;
		}
		else if ( objectpicker.event == 'done' )
		{
			objectpicker.done();
			break;
		}
		else if ( objectpicker.event == 'addtrimpoints' || objectpicker.event == 'isocurve' )
		{
			// When the add trim points button is pushed, we switch to picking points that
			// will be used as additional trim points.
			
			// Make sure the object picker is done first.
			objectpicker.done();
			
			var iso = (objectpicker.event == 'isocurve');
			var isofactories = moi.createList();
			var isofactory = false;
			var isoface = false;
			if ( iso )
			{
				isoface = objects.item(0);
				if ( isoface.isBRep )
					isoface = isoface.getFaces().item(0);			
			}
		
			var pointpicker = moi.ui.createPointPicker();
			pointpicker.disableStraightSnap = true;
			pointpicker.disableTanPerpObjectSnap = true;
			pointpicker.enableOnObjectSnap = true;
			if ( iso )
				pointpicker.restrictToObject( objects.item(0) );
			
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SelectCuttersPrompt' );
			moi.ui.hideUI( 'DeleteCuttingObjectsContainer' );
			moi.ui.hideUI( 'CurveCutterOptions' );
			moi.ui.hideUI( 'SurfaceCutterOptions' );
			
			if ( iso )
			{
				moi.ui.showUI( 'PickIsocurvePrompt' );
				moi.ui.showUI( 'IsocurveOptions' );
			}
			else
			{
				moi.ui.showUI( 'PickTrimPointsPrompt' );
			}
		
			moi.ui.endUIUpdate();
			
			while ( 1 )
			{
				if ( iso && !isofactory )
				{
					isofactory = moi.command.createFactory( 'isocurve' );
					isofactories.add( isofactory );
					isofactory.setInput( 0, isoface );
					isofactory.setInput( 2, moi.ui.commandUI.isodir.value );
				
					pointpicker.clearBindings();
					pointpicker.bindResultPt( isofactory.getInput(1) );
				}
			
				if ( !pointpicker.waitForEvent() )
					return false;
					
				if ( pointpicker.event == 'done' )
					break;
					
				if ( pointpicker.event == 'finished' )
				{
					if ( iso )
					{
						isofactory = false;
						
						var isoinfo = moi.createList();
						isoinfo.add( pointpicker.pt );
						isoinfo.add( moi.ui.commandUI.isodir.value );
						factory.addToListInput( 6, isoinfo );					
					}
					else
					{
						// On a successful pick, add a trim point to the factory's trim
						// point list input.
						factory.addToListInput( 6, pointpicker.pt );
					}
				}
				
				if ( pointpicker.event == 'isodir' && isofactory )
					isofactory.setInput( 2, moi.ui.commandUI.isodir.value );
			}
			
			isofactories.callMethod( 'cancel' );
			
			moi.ui.clearPickedPoints();
				
			break;
		}
	}
	
	var cutters = objectpicker.objects;
	
	// If 'done' was pushed without selecting anything else, then the objects to trim
	// are also used as cutters.
	if ( cutters.length == 0 )
		cutters = objects;

	// Bind the removekeepmode select to the factory's input.
	moi.ui.bindUIToInput( 'removekeepmode', 'value', factory.getInput(3) );

	factory.setInput( 7, moi.ui.commandUI.deletecuttingobjects.value );

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectCuttersPrompt' );
	moi.ui.hideUI( 'DeleteCuttingObjectsContainer' );
	moi.ui.hideUI( 'PickIsocurvePrompt' );
	moi.ui.hideUI( 'PickTrimPointsPrompt' );
	moi.ui.hideUI( 'CurveCutterOptions' );
	moi.ui.hideUI( 'SurfaceCutterOptions' );
	moi.ui.hideUI( 'IsocurveOptions' );	
	moi.ui.showUI( 'RemoveKeepOptions' );
	
	if ( moi.ui.commandUI.removekeepmode.value == 'keep' )
		moi.ui.showUI( 'SelectPiecesToKeep' );
	else
		moi.ui.showUI( 'SelectPiecesToRemove' );
	
	moi.ui.endUIUpdate();

	factory.setInput( 0, objects );
	factory.setInput( 1, cutters );
	var HaveFragments = factory.generateFragments();
	
	if ( HaveFragments )
	{
		// Now only allow top-level objects to be picked, since we only want to pick fragments.
		objectpicker.resetAllow();
		objectpicker.allowTopLevelObjects();
			
		while ( 1 )
		{
			if ( !objectpicker.waitForEvent() )
				return false;
				
			if ( objectpicker.event == 'finished' )
			{
				break;
			}
			else if ( objectpicker.event == 'done' || objectpicker.event == 'Delete' )
			{
				objectpicker.done();
				break;
			}
			else if ( objectpicker.event == 'removekeepmode' )
			{
				moi.ui.beginUIUpdate();

				if ( moi.ui.commandUI.removekeepmode.value == 'keep' )
				{
					moi.ui.showUI( 'SelectPiecesToKeep' );
					moi.ui.hideUI( 'SelectPiecesToRemove' );
				}
				else
				{
					moi.ui.showUI( 'SelectPiecesToRemove' );
					moi.ui.hideUI( 'SelectPiecesToKeep' );
				}
				
				moi.ui.endUIUpdate();
			}
		}
		
		// Set the selected fragments on the factory.
		factory.setInput( 2, objectpicker.objects );
	}

	factory.setInput( 8, moi.ui.commandUI.keepalljoined.value );
	
	factory.finishedPickingFragments();

	factory.update();
	factory.commit();
}

DoTrim();
